# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateStackDetails(object):
    """
    Specifies which fields and the data for each to update on the specified stack.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateStackDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateStackDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateStackDetails.
        :type description: str

        :param config_source:
            The value to assign to the config_source property of this UpdateStackDetails.
        :type config_source: UpdateConfigSourceDetails

        :param variables:
            The value to assign to the variables property of this UpdateStackDetails.
        :type variables: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateStackDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateStackDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'config_source': 'UpdateConfigSourceDetails',
            'variables': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'config_source': 'configSource',
            'variables': 'variables',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._config_source = None
        self._variables = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateStackDetails.
        The name of the stack.


        :return: The display_name of this UpdateStackDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateStackDetails.
        The name of the stack.


        :param display_name: The display_name of this UpdateStackDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateStackDetails.
        Description of the stack.


        :return: The description of this UpdateStackDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateStackDetails.
        Description of the stack.


        :param description: The description of this UpdateStackDetails.
        :type: str
        """
        self._description = description

    @property
    def config_source(self):
        """
        Gets the config_source of this UpdateStackDetails.

        :return: The config_source of this UpdateStackDetails.
        :rtype: UpdateConfigSourceDetails
        """
        return self._config_source

    @config_source.setter
    def config_source(self, config_source):
        """
        Sets the config_source of this UpdateStackDetails.

        :param config_source: The config_source of this UpdateStackDetails.
        :type: UpdateConfigSourceDetails
        """
        self._config_source = config_source

    @property
    def variables(self):
        """
        Gets the variables of this UpdateStackDetails.
        Terraform variables associated with this resource.
        The maximum number of variables supported is 100.
        The maximum size of each variable, including both name and value, is 4096 bytes.
        Example: `{\"CompartmentId\": \"compartment-id-value\"}`


        :return: The variables of this UpdateStackDetails.
        :rtype: dict(str, str)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """
        Sets the variables of this UpdateStackDetails.
        Terraform variables associated with this resource.
        The maximum number of variables supported is 100.
        The maximum size of each variable, including both name and value, is 4096 bytes.
        Example: `{\"CompartmentId\": \"compartment-id-value\"}`


        :param variables: The variables of this UpdateStackDetails.
        :type: dict(str, str)
        """
        self._variables = variables

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateStackDetails.
        Free-form tags associated with this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateStackDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateStackDetails.
        Free-form tags associated with this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateStackDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateStackDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateStackDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateStackDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
