/**
 * last modify : 2020-02-11 12:09
 */

const puppeteer = require('puppeteer');

const executablePath = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
const static_args = "--no-first-run --start-maximized --disable-infobars";

let watchPageRequests = async function(page) {
    //log requests
    // page.on('request', async(request) => {
    //     console.log(request.url());
    // });
};

let tryFillForm = async function(page, autoFillInfo) {
    try {
        await page.evaluateOnNewDocument(() => {
            Object.defineProperty(navigator, 'webdriver', {
                get: () => false,
            });
        });
        let waitEntry = page;
        for(let i = 0; i < autoFillInfo.length; i++) {
            let info = autoFillInfo[i];
            if('iframe' == info.type) {
                //await page.waitFor(5000);
                await page.waitForSelector(info.selector, {timeout : 120000});
                let frames = await page.frames();
                //frames.forEach(f=>console.log(f.url()));
                let iframe = frames[frames.length-1];
                //console.log(iframe.url());
                waitEntry = iframe;
                break;
            }
        }
        for(let i = 0; i < autoFillInfo.length; i++) {
            let info = autoFillInfo[i];
            if('iframe' != info.type) {
                await waitEntry.waitForSelector(info.selector, {timeout : 120000});
            }
        }
        for(let i = 0; i < autoFillInfo.length; i++) {
            let info = autoFillInfo[i];
            let type = info.type;
            if('iframe' != type) {
                if(!type) {
                    type = await waitEntry.evaluate((selector) => {
                        let element = document.querySelector(selector);
                        if(element) {
                            let nodeName = element.nodeName.toLowerCase();
                            let type = nodeName;
                            if(nodeName == 'input') {
                                type = element.type || 'text';
                            }
                            if(type == 'submit') {
                                type = 'button';
                            }
                            return type;
                        }
                        return null;
                    }, info.selector);
                }
                if(type) {
                    if(type == 'text' || type == 'password') {//填充节点
                        //有些节点必须通过type来改变值，有些节点只能直接改变value，所以两个都做，先type然后再改值
                        await waitEntry.type(info.selector, info.value);
                        await waitEntry.evaluate((data) => {
                            return document.querySelector(data.selector).value = data.value
                        }, info);
                    } else if(type == 'select') {//combbox
                        await waitEntry.select(info.selector, info.value);
                    } else if(type == 'button') {
                        waitEntry.click(info.selector, {delay : 1000});
                    } else {
                        waitEntry.click(info.selector);
                    }
                }
            }
        }
    } catch(e) {
        console.error(e);
    }
};

const watch = async function(params) {
    let autoFillInfo = params['autoFillInfo'];
    let finallyArgs = params['args'] + ' ' + static_args;
    let chromeArgs = finallyArgs.split(/\s+/);
    let url = chromeArgs[0];
    let args = chromeArgs.slice(1);

    const browser = await puppeteer.launch({
        executablePath : executablePath,
        ignoreHTTPSErrors : false,
        headless: false,
        defaultViewport : null,
        devtools: false,
        args : args
    });
    browser.on('targetcreated', async(target) => {
        if (target.type() !== 'page') {
            return;
        } else {
            await watchPageRequests(await target.page());
        }
    });
    let page = null;
    const pages = await browser.pages();
    if(pages.length > 0) {
        page = pages[0];
    } else {
        page = await browser.newPage();
    }
    await watchPageRequests(page);
    try{
        let target = url;
        if(!/^https?:\/\//i.test(target)) {
            target = 'http://' + url;
        }
        //await page.goto(target);
        await page.evaluate((t)=>{
            window.location.href = t;
        }, target);
    } catch(ignore) {}//ssl error may

    if('null' != autoFillInfo) {
        await tryFillForm(page, autoFillInfo);
    }
};

module.exports = watch;