/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.demo.controller;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.PageDomain;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.page.TableSupport;
import com.ruoyi.common.core.text.Convert;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.web.controller.demo.domain.CustomerModel;
import com.ruoyi.web.controller.demo.domain.UserOperateModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/demo/operate"})
public class DemoOperateController
extends BaseController {
    private String prefix = "demo/operate";
    private static final Map<Integer, UserOperateModel> users = new LinkedHashMap();

    public DemoOperateController() {
        users.put(1, new UserOperateModel(1, "1000001", "\u6d4b\u8bd51", "0", "15888888888", "ry@qq.com", 150.0, "0"));
        users.put(2, new UserOperateModel(2, "1000002", "\u6d4b\u8bd52", "1", "15666666666", "ry@qq.com", 180.0, "1"));
        users.put(3, new UserOperateModel(3, "1000003", "\u6d4b\u8bd53", "0", "15666666666", "ry@qq.com", 110.0, "1"));
        users.put(4, new UserOperateModel(4, "1000004", "\u6d4b\u8bd54", "1", "15666666666", "ry@qq.com", 220.0, "1"));
        users.put(5, new UserOperateModel(5, "1000005", "\u6d4b\u8bd55", "0", "15666666666", "ry@qq.com", 140.0, "1"));
        users.put(6, new UserOperateModel(6, "1000006", "\u6d4b\u8bd56", "1", "15666666666", "ry@qq.com", 330.0, "1"));
        users.put(7, new UserOperateModel(7, "1000007", "\u6d4b\u8bd57", "0", "15666666666", "ry@qq.com", 160.0, "1"));
        users.put(8, new UserOperateModel(8, "1000008", "\u6d4b\u8bd58", "1", "15666666666", "ry@qq.com", 170.0, "1"));
        users.put(9, new UserOperateModel(9, "1000009", "\u6d4b\u8bd59", "0", "15666666666", "ry@qq.com", 180.0, "1"));
        users.put(10, new UserOperateModel(10, "1000010", "\u6d4b\u8bd510", "0", "15666666666", "ry@qq.com", 210.0, "1"));
        users.put(11, new UserOperateModel(11, "1000011", "\u6d4b\u8bd511", "1", "15666666666", "ry@qq.com", 110.0, "1"));
        users.put(12, new UserOperateModel(12, "1000012", "\u6d4b\u8bd512", "0", "15666666666", "ry@qq.com", 120.0, "1"));
        users.put(13, new UserOperateModel(13, "1000013", "\u6d4b\u8bd513", "1", "15666666666", "ry@qq.com", 380.0, "1"));
        users.put(14, new UserOperateModel(14, "1000014", "\u6d4b\u8bd514", "0", "15666666666", "ry@qq.com", 280.0, "1"));
        users.put(15, new UserOperateModel(15, "1000015", "\u6d4b\u8bd515", "0", "15666666666", "ry@qq.com", 570.0, "1"));
        users.put(16, new UserOperateModel(16, "1000016", "\u6d4b\u8bd516", "1", "15666666666", "ry@qq.com", 260.0, "1"));
        users.put(17, new UserOperateModel(17, "1000017", "\u6d4b\u8bd517", "1", "15666666666", "ry@qq.com", 210.0, "1"));
        users.put(18, new UserOperateModel(18, "1000018", "\u6d4b\u8bd518", "1", "15666666666", "ry@qq.com", 340.0, "1"));
        users.put(19, new UserOperateModel(19, "1000019", "\u6d4b\u8bd519", "1", "15666666666", "ry@qq.com", 160.0, "1"));
        users.put(20, new UserOperateModel(20, "1000020", "\u6d4b\u8bd520", "1", "15666666666", "ry@qq.com", 220.0, "1"));
        users.put(21, new UserOperateModel(21, "1000021", "\u6d4b\u8bd521", "1", "15666666666", "ry@qq.com", 120.0, "1"));
        users.put(22, new UserOperateModel(22, "1000022", "\u6d4b\u8bd522", "1", "15666666666", "ry@qq.com", 130.0, "1"));
        users.put(23, new UserOperateModel(23, "1000023", "\u6d4b\u8bd523", "1", "15666666666", "ry@qq.com", 490.0, "1"));
        users.put(24, new UserOperateModel(24, "1000024", "\u6d4b\u8bd524", "1", "15666666666", "ry@qq.com", 570.0, "1"));
        users.put(25, new UserOperateModel(25, "1000025", "\u6d4b\u8bd525", "1", "15666666666", "ry@qq.com", 250.0, "1"));
        users.put(26, new UserOperateModel(26, "1000026", "\u6d4b\u8bd526", "1", "15666666666", "ry@qq.com", 250.0, "1"));
    }

    @GetMapping(value={"/table"})
    public String table() {
        return this.prefix + "/table";
    }

    @GetMapping(value={"/other"})
    public String other() {
        return this.prefix + "/other";
    }

    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(UserOperateModel userModel) {
        PageDomain pageDomain;
        TableDataInfo rspData = new TableDataInfo();
        ArrayList userList = new ArrayList(users.values());
        if (StringUtils.isNotEmpty((String)userModel.getSearchValue())) {
            userList.clear();
            for (Map.Entry entry : users.entrySet()) {
                if (!((UserOperateModel)entry.getValue()).getUserName().equals(userModel.getSearchValue())) continue;
                userList.add(entry.getValue());
            }
        } else if (StringUtils.isNotEmpty((String)userModel.getUserName())) {
            userList.clear();
            for (Map.Entry entry : users.entrySet()) {
                if (!((UserOperateModel)entry.getValue()).getUserName().equals(userModel.getUserName())) continue;
                userList.add(entry.getValue());
            }
        }
        if (null == (pageDomain = TableSupport.buildPageRequest()).getPageNum() || null == pageDomain.getPageSize()) {
            rspData.setRows(userList);
            rspData.setTotal((long)userList.size());
            return rspData;
        }
        Integer pageNum = (pageDomain.getPageNum() - 1) * 10;
        Integer pageSize = pageDomain.getPageNum() * 10;
        if (pageSize > userList.size()) {
            pageSize = userList.size();
        }
        rspData.setRows(userList.subList(pageNum, pageSize));
        rspData.setTotal((long)userList.size());
        return rspData;
    }

    @GetMapping(value={"/add"})
    public String add(ModelMap mmap) {
        return this.prefix + "/add";
    }

    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(UserOperateModel user) {
        Integer userId = users.size() + 1;
        user.setUserId(userId.intValue());
        return AjaxResult.success((Object)users.put(userId, user));
    }

    @PostMapping(value={"/customer/add"})
    @ResponseBody
    public AjaxResult addSave(CustomerModel customerModel) {
        System.out.println(customerModel.toString());
        return AjaxResult.success();
    }

    @GetMapping(value={"/edit/{userId}"})
    public String edit(@PathVariable(value="userId") Integer userId, ModelMap mmap) {
        mmap.put((Object)"user", users.get(userId));
        return this.prefix + "/edit";
    }

    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(UserOperateModel user) {
        return AjaxResult.success((Object)users.put(user.getUserId(), user));
    }

    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(UserOperateModel user) {
        ArrayList list = new ArrayList(users.values());
        ExcelUtil util = new ExcelUtil(UserOperateModel.class);
        return util.exportExcel(list, "\u7528\u6237\u6570\u636e");
    }

    @GetMapping(value={"/importTemplate"})
    @ResponseBody
    public AjaxResult importTemplate() {
        ExcelUtil util = new ExcelUtil(UserOperateModel.class);
        return util.importTemplateExcel("\u7528\u6237\u6570\u636e");
    }

    @PostMapping(value={"/importData"})
    @ResponseBody
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(UserOperateModel.class);
        List userList = util.importExcel(file.getInputStream());
        String message = this.importUser(userList, Boolean.valueOf(updateSupport));
        return AjaxResult.success((String)message);
    }

    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        Integer[] userIds;
        for (Integer userId : userIds = Convert.toIntArray((String)ids)) {
            users.remove(userId);
        }
        return AjaxResult.success();
    }

    @GetMapping(value={"/detail/{userId}"})
    public String detail(@PathVariable(value="userId") Integer userId, ModelMap mmap) {
        mmap.put((Object)"user", users.get(userId));
        return this.prefix + "/detail";
    }

    @PostMapping(value={"/clean"})
    @ResponseBody
    public AjaxResult clean() {
        users.clear();
        return this.success();
    }

    public String importUser(List<UserOperateModel> userList, Boolean isUpdateSupport) {
        if (StringUtils.isNull(userList) || userList.size() == 0) {
            throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        for (UserOperateModel user : userList) {
            try {
                boolean userFlag = false;
                for (Map.Entry entry : users.entrySet()) {
                    if (!((UserOperateModel)entry.getValue()).getUserName().equals(user.getUserName())) continue;
                    userFlag = true;
                    break;
                }
                if (!userFlag) {
                    Integer userId = users.size() + 1;
                    user.setUserId(userId.intValue());
                    users.put(userId, user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u7528\u6237 " + user.getUserName() + " \u5bfc\u5165\u6210\u529f");
                    continue;
                }
                if (isUpdateSupport.booleanValue()) {
                    users.put(user.getUserId(), user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u7528\u6237 " + user.getUserName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                failureMsg.append("<br/>" + ++failureNum + "\u3001\u7528\u6237 " + user.getUserName() + " \u5df2\u5b58\u5728");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new ServiceException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }
}

