/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.monitor;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.shiro.service.SysPasswordService;
import com.ruoyi.system.domain.SysLogininfor;
import com.ruoyi.system.service.ISysLogininforService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor/logininfor"})
public class SysLogininforController
extends BaseController {
    private String prefix = "monitor/logininfor";
    @Autowired
    private ISysLogininforService logininforService;
    @Autowired
    private SysPasswordService passwordService;

    @RequiresPermissions(value={"monitor:logininfor:view"})
    @GetMapping
    public String logininfor() {
        return this.prefix + "/logininfor";
    }

    @RequiresPermissions(value={"monitor:logininfor:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysLogininfor logininfor) {
        this.startPage();
        List list = this.logininforService.selectLogininforList(logininfor);
        return this.getDataTable(list);
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"monitor:logininfor:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysLogininfor logininfor) {
        List list = this.logininforService.selectLogininforList(logininfor);
        ExcelUtil util = new ExcelUtil(SysLogininfor.class);
        return util.exportExcel(list, "\u767b\u5f55\u65e5\u5fd7");
    }

    @RequiresPermissions(value={"monitor:logininfor:remove"})
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.logininforService.deleteLogininforByIds(ids));
    }

    @RequiresPermissions(value={"monitor:logininfor:remove"})
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @PostMapping(value={"/clean"})
    @ResponseBody
    public AjaxResult clean() {
        this.logininforService.cleanLogininfor();
        return this.success();
    }

    @RequiresPermissions(value={"monitor:logininfor:unlock"})
    @Log(title="\u8d26\u6237\u89e3\u9501", businessType=BusinessType.OTHER)
    @PostMapping(value={"/unlock"})
    @ResponseBody
    public AjaxResult unlock(String loginName) {
        this.passwordService.clearLoginRecordCache(loginName);
        return this.success();
    }
}

