/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.ServletUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.ConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SysLoginController
extends BaseController {
    @Value(value="${shiro.rememberMe.enabled: false}")
    private boolean rememberMe;
    @Autowired
    private ConfigService configService;

    @GetMapping(value={"/login"})
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap mmap) {
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            return ServletUtils.renderString((HttpServletResponse)response, (String)"{\"code\":\"1\",\"msg\":\"\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6\u3002\u8bf7\u91cd\u65b0\u767b\u5f55\"}");
        }
        mmap.put((Object)"isRemembered", (Object)this.rememberMe);
        mmap.put((Object)"isAllowRegister", (Object)this.configService.getKey("sys.account.registerUser"));
        return "login";
    }

    @PostMapping(value={"/login"})
    @ResponseBody
    public AjaxResult ajaxLogin(String username, String password, Boolean rememberMe) {
        UsernamePasswordToken token = new UsernamePasswordToken(username, password, rememberMe.booleanValue());
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            return this.success();
        }
        catch (AuthenticationException e) {
            String msg = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef";
            if (StringUtils.isNotEmpty((String)e.getMessage())) {
                msg = e.getMessage();
            }
            return this.error(msg);
        }
    }

    @GetMapping(value={"/unauth"})
    public String unauth() {
        return "error/unauth";
    }
}

