/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.SysNotice;
import com.ruoyi.system.service.ISysNoticeService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/notice"})
public class SysNoticeController
extends BaseController {
    private String prefix = "system/notice";
    @Autowired
    private ISysNoticeService noticeService;

    @RequiresPermissions(value={"system:notice:view"})
    @GetMapping
    public String notice() {
        return this.prefix + "/notice";
    }

    @RequiresPermissions(value={"system:notice:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(SysNotice notice) {
        this.startPage();
        List list = this.noticeService.selectNoticeList(notice);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"system:notice:add"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(SysNotice notice) {
        notice.setCreateBy(this.getLoginName());
        return this.toAjax(this.noticeService.insertNotice(notice));
    }

    @GetMapping(value={"/edit/{noticeId}"})
    public String edit(@PathVariable(value="noticeId") Long noticeId, ModelMap mmap) {
        mmap.put((Object)"notice", (Object)this.noticeService.selectNoticeById(noticeId));
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"system:notice:edit"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(SysNotice notice) {
        notice.setUpdateBy(this.getLoginName());
        return this.toAjax(this.noticeService.updateNotice(notice));
    }

    @RequiresPermissions(value={"system:notice:remove"})
    @Log(title="\u901a\u77e5\u516c\u544a", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.noticeService.deleteNoticeByIds(ids));
    }
}

