/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.teleMonitor;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.teleMonitor.domain.ConfigEnterpriseMonitorInfo;
import com.ruoyi.teleMonitor.service.IConfigEnterpriseMonitorInfoService;
import com.ruoyi.teleMonitor.service.IConfigProjectGroupService;
import com.ruoyi.teleMonitor.service.IConfigTelegramBotService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/teleMonitor/enterprise"})
public class ConfigEnterpriseMonitorInfoController
extends BaseController {
    private String prefix = "teleMonitor/enterprise";
    @Autowired
    private IConfigEnterpriseMonitorInfoService configEnterpriseMonitorInfoService;
    @Autowired
    private IConfigTelegramBotService configTelegramBotService;
    @Autowired
    private IConfigProjectGroupService configProjectGroupService;

    @RequiresPermissions(value={"teleMonitor:enterprise:view"})
    @GetMapping
    public String enterprise() {
        return this.prefix + "/enterprise";
    }

    @RequiresPermissions(value={"teleMonitor:enterprise:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(ConfigEnterpriseMonitorInfo configEnterpriseMonitorInfo) {
        this.startPage();
        List list = this.configEnterpriseMonitorInfoService.selectConfigEnterpriseMonitorInfoList(configEnterpriseMonitorInfo);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"teleMonitor:enterprise:export"})
    @Log(title="\u4e91\u4f01\u4e1a\u76d1\u542c", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(ConfigEnterpriseMonitorInfo configEnterpriseMonitorInfo) {
        List list = this.configEnterpriseMonitorInfoService.selectConfigEnterpriseMonitorInfoList(configEnterpriseMonitorInfo);
        ExcelUtil util = new ExcelUtil(ConfigEnterpriseMonitorInfo.class);
        return util.exportExcel(list, "\u4e91\u4f01\u4e1a\u76d1\u542c\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add(ModelMap mmap) {
        List configProjectGroups = this.configProjectGroupService.selectConfigProjectGroupList(null);
        mmap.put((Object)"configProjectGroups", (Object)configProjectGroups);
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"teleMonitor:enterprise:add"})
    @Log(title="\u4e91\u4f01\u4e1a\u76d1\u542c", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(ConfigEnterpriseMonitorInfo configEnterpriseMonitorInfo) {
        return this.toAjax(this.configEnterpriseMonitorInfoService.insertConfigEnterpriseMonitorInfo(configEnterpriseMonitorInfo));
    }

    @GetMapping(value={"/edit/{id}"})
    public String edit(@PathVariable(value="id") Long id, ModelMap mmap) {
        ConfigEnterpriseMonitorInfo configEnterpriseMonitorInfo = this.configEnterpriseMonitorInfoService.selectConfigEnterpriseMonitorInfoById(id);
        List configProjectGroups = this.configProjectGroupService.selectConfigProjectGroupList(null);
        mmap.put((Object)"configProjectGroups", (Object)configProjectGroups);
        mmap.put((Object)"configEnterpriseMonitorInfo", (Object)configEnterpriseMonitorInfo);
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"teleMonitor:enterprise:edit"})
    @Log(title="\u4e91\u4f01\u4e1a\u76d1\u542c", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(ConfigEnterpriseMonitorInfo configEnterpriseMonitorInfo) {
        return this.toAjax(this.configEnterpriseMonitorInfoService.updateConfigEnterpriseMonitorInfo(configEnterpriseMonitorInfo));
    }

    @RequiresPermissions(value={"teleMonitor:enterprise:remove"})
    @Log(title="\u4e91\u4f01\u4e1a\u76d1\u542c", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.configEnterpriseMonitorInfoService.deleteConfigEnterpriseMonitorInfoByIds(ids));
    }
}

