/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.teleMonitor;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.teleMonitor.domain.ConfigTelegramBot;
import com.ruoyi.teleMonitor.service.IConfigTelegramBotService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/teleMonitor/teleMonitorBot"})
public class ConfigTelegramBotController
extends BaseController {
    private String prefix = "teleMonitor/teleMonitorBot";
    @Autowired
    private IConfigTelegramBotService configTelegramBotService;

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:view"})
    @GetMapping
    public String teleMonitorBot() {
        return this.prefix + "/teleMonitorBot";
    }

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:list"})
    @PostMapping(value={"/list"})
    @ResponseBody
    public TableDataInfo list(ConfigTelegramBot configTelegramBot) {
        this.startPage();
        List list = this.configTelegramBotService.selectConfigTelegramBotList(configTelegramBot);
        return this.getDataTable(list);
    }

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:export"})
    @Log(title="\u7535\u62a5\u673a\u5668\u4eba\u914d\u7f6e", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(ConfigTelegramBot configTelegramBot) {
        List list = this.configTelegramBotService.selectConfigTelegramBotList(configTelegramBot);
        ExcelUtil util = new ExcelUtil(ConfigTelegramBot.class);
        return util.exportExcel(list, "\u7535\u62a5\u673a\u5668\u4eba\u914d\u7f6e\u6570\u636e");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:add"})
    @Log(title="\u7535\u62a5\u673a\u5668\u4eba\u914d\u7f6e", businessType=BusinessType.INSERT)
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(ConfigTelegramBot configTelegramBot) {
        return this.toAjax(this.configTelegramBotService.insertConfigTelegramBot(configTelegramBot));
    }

    @GetMapping(value={"/edit/{botId}"})
    public String edit(@PathVariable(value="botId") Long botId, ModelMap mmap) {
        ConfigTelegramBot configTelegramBot = this.configTelegramBotService.selectConfigTelegramBotByBotId(botId);
        mmap.put((Object)"configTelegramBot", (Object)configTelegramBot);
        return this.prefix + "/edit";
    }

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:edit"})
    @Log(title="\u7535\u62a5\u673a\u5668\u4eba\u914d\u7f6e", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(ConfigTelegramBot configTelegramBot) {
        return this.toAjax(this.configTelegramBotService.updateConfigTelegramBot(configTelegramBot));
    }

    @RequiresPermissions(value={"teleMonitor:teleMonitorBot:remove"})
    @Log(title="\u7535\u62a5\u673a\u5668\u4eba\u914d\u7f6e", businessType=BusinessType.DELETE)
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        return this.toAjax(this.configTelegramBotService.deleteConfigTelegramBotByBotIds(ids));
    }
}

