/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.web.controller.system;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.Ztree;
import com.ruoyi.common.core.domain.entity.SysDictType;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDictTypeService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/dict"})
public class SysDictTypeController
extends BaseController {
    private String prefix = "system/dict/type";
    @Autowired
    private ISysDictTypeService dictTypeService;

    @RequiresPermissions(value={"system:dict:view"})
    @GetMapping
    public String dictType() {
        return this.prefix + "/type";
    }

    @PostMapping(value={"/list"})
    @RequiresPermissions(value={"system:dict:list"})
    @ResponseBody
    public TableDataInfo list(SysDictType dictType) {
        this.startPage();
        List list = this.dictTypeService.selectDictTypeList(dictType);
        return this.getDataTable(list);
    }

    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:dict:export"})
    @PostMapping(value={"/export"})
    @ResponseBody
    public AjaxResult export(SysDictType dictType) {
        List list = this.dictTypeService.selectDictTypeList(dictType);
        ExcelUtil util = new ExcelUtil(SysDictType.class);
        return util.exportExcel(list, "\u5b57\u5178\u7c7b\u578b");
    }

    @GetMapping(value={"/add"})
    public String add() {
        return this.prefix + "/add";
    }

    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.INSERT)
    @RequiresPermissions(value={"system:dict:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public AjaxResult addSave(@Validated SysDictType dict) {
        if ("1".equals(this.dictTypeService.checkDictTypeUnique(dict))) {
            return this.error("\u65b0\u589e\u5b57\u5178'" + dict.getDictName() + "'\u5931\u8d25\uff0c\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        dict.setCreateBy(this.getLoginName());
        return this.toAjax(this.dictTypeService.insertDictType(dict));
    }

    @GetMapping(value={"/edit/{dictId}"})
    public String edit(@PathVariable(value="dictId") Long dictId, ModelMap mmap) {
        mmap.put((Object)"dict", (Object)this.dictTypeService.selectDictTypeById(dictId));
        return this.prefix + "/edit";
    }

    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.UPDATE)
    @RequiresPermissions(value={"system:dict:edit"})
    @PostMapping(value={"/edit"})
    @ResponseBody
    public AjaxResult editSave(@Validated SysDictType dict) {
        if ("1".equals(this.dictTypeService.checkDictTypeUnique(dict))) {
            return this.error("\u4fee\u6539\u5b57\u5178'" + dict.getDictName() + "'\u5931\u8d25\uff0c\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        dict.setUpdateBy(this.getLoginName());
        return this.toAjax(this.dictTypeService.updateDictType(dict));
    }

    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.DELETE)
    @RequiresPermissions(value={"system:dict:remove"})
    @PostMapping(value={"/remove"})
    @ResponseBody
    public AjaxResult remove(String ids) {
        this.dictTypeService.deleteDictTypeByIds(ids);
        return this.success();
    }

    @RequiresPermissions(value={"system:dict:remove"})
    @Log(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.CLEAN)
    @GetMapping(value={"/refreshCache"})
    @ResponseBody
    public AjaxResult refreshCache() {
        this.dictTypeService.resetDictCache();
        return this.success();
    }

    @RequiresPermissions(value={"system:dict:list"})
    @GetMapping(value={"/detail/{dictId}"})
    public String detail(@PathVariable(value="dictId") Long dictId, ModelMap mmap) {
        mmap.put((Object)"dict", (Object)this.dictTypeService.selectDictTypeById(dictId));
        mmap.put((Object)"dictList", (Object)this.dictTypeService.selectDictTypeAll());
        return "system/dict/data/data";
    }

    @PostMapping(value={"/checkDictTypeUnique"})
    @ResponseBody
    public String checkDictTypeUnique(SysDictType dictType) {
        return this.dictTypeService.checkDictTypeUnique(dictType);
    }

    @GetMapping(value={"/selectDictTree/{columnId}/{dictType}"})
    public String selectDeptTree(@PathVariable(value="columnId") Long columnId, @PathVariable(value="dictType") String dictType, ModelMap mmap) {
        mmap.put((Object)"columnId", (Object)columnId);
        mmap.put((Object)"dict", (Object)this.dictTypeService.selectDictTypeByType(dictType));
        return this.prefix + "/tree";
    }

    @GetMapping(value={"/treeData"})
    @ResponseBody
    public List<Ztree> treeData() {
        List ztrees = this.dictTypeService.selectDictTree(new SysDictType());
        return ztrees;
    }
}

